#!/usr/bin/env perl

use strict;
use warnings;

use FindBin;
use lib "$FindBin::Bin/";

my $cachefile="/tmp/processor-stats.cache";

use SnmpPass;

#
# Processes an input file and converts it to SNMP variables.  Modify the following vars:
# $cachecommand - reads data
# $baseoid      - base OID to work from
# $headerlines  - number of header lines expected
#

my $baseoid = ".1.3.6.1.3.7";

my $cachecommand = "cat /tmp/processor-stats.cache | awk '{\$9=100-\$9; print \$0}'";
my $headerlines = 0;

SnmpPass::runmainloop($baseoid, $cachecommand, $headerlines);

