package SnmpPass;

use strict;
use warnings;
use Data::Dumper;
use bignum;

use constant debug => 0;
my $base_oid;
my $req;
my $mibtime = 0;
my $cache;
my $cachecommand;
my $headerlines;
my $devices;
my $base;

my $processdelegate;

# Results from iostat are cached for some seconds so that an
# SNMP walk doesn't result in collecting data over and over again:
my $cache_secs = 30;

sub runmainloop {

        $base_oid = shift;
        $cachecommand = shift;
        $headerlines = shift;
        $base = shift || 1;

        # Switch on autoflush
        $| = 1;

        while (my $cmd = <STDIN>) {
                chomp $cmd;

                if ($cmd eq "PING") {
                        print "PONG\n";
                } elsif ($cmd eq "get") {
                        my $oid_in = <STDIN>;
                        chomp $oid_in;
                        process();
                        getoid($oid_in);
                } elsif ($cmd eq "getnext") {
                        my $oid_in = <STDIN>;
                        chomp $oid_in;
                        process();
                        my $found = 0;
                        my $next = getnextoid($oid_in);
                        getoid($next);
                } elsif ($cmd eq "walkall") {
                        my $oid = getnextoid("1");
                        process();
                        while(getoid($oid)) {
                                $oid = getnextoid($oid);
                        }
                } else {
                        # Unknown command
                }
        }
}

sub process {
        # Determine if we can use the cache...
        return if (time - $mibtime < $cache_secs);

        my %local = processTable();
        $cache = \%local;

        $mibtime = time;
}

sub getoid {
    my $oid = shift(@_);
    print "Fetching oid : $oid\n" if (debug);
    if ( $oid =~ /^$base_oid\.1.(\d+)\.(\d+).*/ && exists( ${$cache}{$oid} ) ) {
        print $oid. "\n";
        if ( $1 == 1 ) {
                        print "integer\n";
                } elsif ( $1 == 2 ) {
            print "string\n";
        } else {
            print "integer\n";
        }
        print ${$cache}{$oid} . "\n";
        } elsif ( $oid =~ /^$base_oid\.0/ && exists( ${$cache}{$oid})) {
                print $oid. "\ninteger\n";
                print ${$cache}{$oid} . "\n";
    } else {
                print "NONE\n";
                return 0;
    }
        return 1;
}

sub getnextoid {
    my $first_oid = shift(@_);
    my $next_oid  = '';
    my $count_id;
    my $index;

        #
        # Since we're not storing the list of OIDs, this is a hack based on knowing
        # the format of the tree we're listing
        #

    if ( $first_oid =~ /$base_oid\.1\.(\d+)\.(\d+).*/ ) {
        print("getnextoid($first_oid): index: $2, count_id: $1\n") if (debug);
        if ( $2 + 1 >= $devices ) {
            $count_id = $1 + 1;
            $index    = 1;
        }
        else {
            $index    = $2 + 1;
            $count_id = $1;
        }
        print(
            "getnextoid($first_oid): NEW - index: $index, count_id: $count_id\n"
        ) if (debug);
        $next_oid = "$base_oid.1.$count_id.$index";
    }
    elsif ( $first_oid =~ /$base_oid\.1\.(\d+).*/ ) {
        $next_oid = "$base_oid.1.$1.1";
    }
        elsif ( $first_oid =~ /$base_oid\.1.*/ ) {
                $next_oid = "$base_oid.1.1.1";
        }
        elsif ( $first_oid =~ /$base_oid\.0.*/ ) {
                $next_oid = "$base_oid.1.1.1";
        }
    elsif ( $first_oid eq $base_oid ) {
        $next_oid = "$base_oid.0";
    }
    else {
        $next_oid = "$base_oid.0";
    }
    print("getnextoid($first_oid): returning $next_oid\n") if (debug);
    return $next_oid;
}

sub convertnum {
        my $input = shift;
        $input =~ /^(\d+(\.\d+)?)([KMGT]?)$/;

        my $num = $1;

        if ($3 eq "K") {
                $num *= 1024.0;
        } elsif ($3 eq "M") {
                $num *= 1024.0 * 1024.0;
        } elsif ($3 eq "G") {
                $num *= 1024.0 * 1024.0 * 1024.0;
        } elsif ($3 eq "T") {
                $num *= 1024.0 * 1024.0 * 1024.0 * 1024.0;
        }

        if ($base != 1) {
                $num = $num / $base;
        }

        $num = int($num + 0.5);

        return $num;
}

#
# Parse the table
#
sub processTable {
        my %stats;

        my $output = `$cachecommand`;
        my @lines = split(/\n/, $output);

        $devices = 1;
        my $l = 0;
        foreach my $line (@lines) {
                next if $l++ < $headerlines;
                chomp $line;                                                            # Trim trailing whitespace
                next if $line eq '';

                my @values = split(/\s+/, $line);

                $stats{"$base_oid.1.1.$devices"} = $devices;                    # Device Index
                $stats{"$base_oid.1.2.$devices"} = shift(@values);      # NAME

                my $index = 3;
                foreach my $val (@values) {
                        $stats{"$base_oid.1.$index.$devices"} = convertnum($val);
                        $index++;
                }
                $devices++;
        }
        $stats{"$base_oid.0"} = $devices - 1;
        print STDERR Dumper(%stats) if (debug);
        return %stats;
}


1;

