# -*- rpm-spec -*-

%define buildxen     1
%define buildkdump   1
%define buildutility 1

%define buildsource  0
%define buildfirmware 1
%define buildextradevel 1

# Control whether we perform a compat. check against published ABI.
#%define with_kabichk        %{?_without_kabichk: 0} %{?!_without_kabichk: 1}
%define with_kabichk 0

# The full kernel uname version
%define uname         2.6.32.43-0.4.1.xs1.8.0.865.170810
%define xen_uname     2.6.32.43-0.4.1.xs1.8.0.865.170810xen
%define kdump_uname   2.6.32.43-0.4.1.xs1.8.0.865.170810kdump
%define utility_uname 2.6.32.43-0.4.1.xs1.8.0.865.170810utility

%define hdrarch      %{_target_cpu}

%ifarch %{ix86}
%define target       %{_target_cpu}

%define target64     x86_64
%define cross64      x86_64-linux-
%define hdrarch      i386
%endif

%ifarch x86_64
%define target       %{_target_cpu}

%define buildxen64   0
%define buildkdump64 0
%endif

%define COMMON_MAKEOPTS %{?_smp_mflags} -s 

# Expects ${flavour} set in the including function and sets
# ${CROSS_COMPILE}, ${TARGET} and ${MAKEOPTS}.
%define DEFINE_MAKEOPTS \
 	case ${flavour} in \
	    *64) CROSS_COMPILE=%{cross64} ; \
                 TARGET=%{target64} ;; \
	    *)   CROSS_COMPILE= ; \
                 TARGET=%{target} ;; \
	esac ; \
	MAKEOPTS="%{COMMON_MAKEOPTS} CROSS_COMPILE=${CROSS_COMPILE}"


#
# First the general kernel 2.6 required versions as per
# Documentation/Changes
#
%define kernel_dot_org_conflicts  ppp <= 2.3.15, pcmcia-cs <= 3.1.20, isdn4k-utils <= 3.0, mount < 2.10r-5, nfs-utils < 1.0.3, e2fsprogs < 1.29, util-linux < 2.10, jfsutils < 1.0.14, reiserfsprogs < 3.6.3, xfsprogs < 2.1.0, procps < 2.0.9, oprofile < 0.5.3

#
# Then a series of requirements that are distribution specific, either
# because we add patches for something, or the older versions have
# problems with the newer kernel or lack certain things that make
# integration in the distro harder than needed.
#
%define package_conflicts  cipe < 1.4.5, tux < 2.1.0, kudzu <= 0.92, initscripts < 7.23, dev < 3.2-7, iptables < 1.2.5-3, bcm5820 < 1.81, nvidia-rh72 <= 1.0, ipw2200-firmware < 2.2

#
# Several packages had bugs in them that became obvious when the NPTL
# threading code got integrated.
#
%define nptl_conflicts SysVinit < 2.84-13, pam < 0.75-48, vixie-cron < 3.0.1-73, privoxy < 3.0.0-8, spamassassin < 2.44-4.8.x,  cups < 1.1.17-13

#
# Packages that need to be installed before the kernel is, because the %post
# scripts use them.
#
%define kernel_prereq  fileutils, module-init-tools, initscripts >= 5.83, mkinitrd >= 4.2.1.6-1

#
# don't use RPM's internal dependency generator, instead
# just use our magic one that finds the versions of kernel modules for
# provides and don't do any requires
# (we used to just turn off AutoReqProv on all packages)
#
%define _use_internal_dependency_generator 0
%define __find_provides %{nil}
%define __find_requires %{nil}

Name: kernel
Vendor: Citrix Systems, Inc.
Group: System Environment/Kernel
License: GPLv2
Version: 2.6.32.43
Release: 0.4.1.xs1.8.0.865.170810
ExclusiveArch: noarch i686 x86_64
ExclusiveOS: Linux
Summary: The Xen port of the Linux kernel.
BuildPreReq: module-init-tools, patch >= 2.5.4, bash >= 2.03, sh-utils, tar
BuildPreReq: bzip2, findutils, gzip, m4, perl, make >= 3.78, gnupg
BuildRequires: gcc >= 2.96-98, binutils >= 2.12, redhat-rpm-config >= 8.0.32.1

Source0: linux-2.6.32.43-0.4.1.xs1.8.0.865.170810.tar.bz2
Source1: kernel-2.6.32.43-0.4.1.xs1.8.0.865.170810-i686-xen.config
Source2: kernel-2.6.32.43-0.4.1.xs1.8.0.865.170810-i686-kdump.config
Source3: kernel-2.6.32.43-0.4.1.xs1.8.0.865.170810-i686-utility.config
Source6: check-kabi
Source5: Module.kabi-xen
Source6: Module.kabi-kdump

BuildRoot: %{_tmppath}/kernel-%{version}-root

%description
This package contains the Linux kernels.

trunk.5ab1b4af1faf.7a7e1b08f843

%package xen
Summary: Development package for building kernel modules to match the xen kernel.
Group: System Environment/Kernel
Provides: kernel = %{xen_uname}
Autoreqprov: no
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}

%description xen
This package contains a Linux kernel configured for use with Xen as
both domain 0 and a guest domain.

trunk.5ab1b4af1faf.7a7e1b08f843

%package xen-devel
Summary: Development package for building kernel modules to match the xen kernel.
Group: System Environment/Kernel
AutoReqProv: no
Requires: kernel-xen = %{uname}
Provides: kernel-devel = %{xen_uname}

%description xen-devel
This package provides kernel headers and makefiles sufficient to build modules
against the %{xen_uname} kernel.

%package headers
Summary: Development package for building user space programs to match the xen kernel.
Group: System Environment/Kernel
AutoReqProv: no
Requires: kernel-xen = %{uname}

%description headers
This package provides kernel headers for user space programs.


trunk.5ab1b4af1faf.7a7e1b08f843

%package utility
Summary: Development package for building kernel modules to match the utility guest kernel.
Group: System Environment/Kernel
Provides: kernel-utility = %{xen_uname}
Autoreqprov: no
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}

%description utility
This package contains a Linux kernel configured for use with Xen as
a utility guest.

trunk.5ab1b4af1faf.7a7e1b08f843

%package utility-devel
Summary: Development package for building kernel modules to match the utility kernel.
Group: System Environment/Kernel
AutoReqProv: no
Requires: kernel-utility = %{uname}
Provides: kernel-devel = %{xen_uname}

%description utility-devel
This package provides kernel headers and makefiles sufficient to build modules
against the %{xen_uname} kernel.

trunk.5ab1b4af1faf.7a7e1b08f843

%package kdump
Summary: Crash dump kernel
Group: System Environment/Kernel
Provides: kernel = %{kdump_uname}
AutoReqProv: no
Prereq: %{kernel_prereq}
Conflicts: %{kernel_dot_org_conflicts}
Conflicts: %{package_conflicts}
Conflicts: %{nptl_conflicts}

%description kdump
This package provides a crash dump kernel.

trunk.5ab1b4af1faf.7a7e1b08f843

%package kdump-devel
Summary: Development package for building kernel modules to match the kdump kernel.
Group: System Environment/Kernel
AutoReqProv: no
Requires: kernel-kdump = %{uname}
Provides: kernel-devel = %{kdump_uname}

%description kdump-devel
This package provides kernel headers and makefiles sufficient to build modules
against the %{kdump_uname} kernel.


%package sourcecode
Summary: The source code for the Linux kernel.
Group: Development/System
Prereq: fileutils
Requires: make >= 3.78
Requires: gcc >= 3.2
Requires: /usr/bin/strip
# for xconfig and gconfig
#Requires: qt-devel, gtk2-devel
Requires: readline-devel ncurses-devel
Provides: kernel-source
#Obsoletes: kernel-source <= 2.6.6

%description sourcecode 
The kernel-sourcecode package contains the source code files for the
Linux kernel.

This package is neither needed nor usable for building external
kernel modules for linking such modules into the default operating
system kernels. For this purpose you require the -devel package.

trunk.5ab1b4af1faf.7a7e1b08f843

#%package doc
#Summary: Various documentation bits found in the kernel source.
#Group: Documentation
#
#%description doc
#This package contains documentation files from the kernel
#source. Various bits of information about the Linux kernel and the
#device drivers shipped with it are documented in these files.
#
#You'll want to install this package if you need a reference to the
#options that can be passed to Linux kernel modules at load time.

%package firmware
Summary: Firmware required by kernel modules
Group: System Environment/Kernel
Provides: kernel-firmware

%description firmware
The kernel-firmware package contains firmware for various hardware devices supported by the
Linux kernel.

%package extra-devel
Summary: Additional kernel header files
Group: System Environment/Kernel

%description extra-devel
The extra-devel package contains header files that are found down a path other than include.

%prep 

%setup -q -n %{name}-%{version} -c
cd linux-2.6.32.43-0.4.1.xs1.8.0.865.170810
#%patch0 -p1
cd ..

Setup() {
	flavour=$1

	%{DEFINE_MAKEOPTS}

	config=%{_sourcedir}/kernel-2.6.32.43-0.4.1.xs1.8.0.865.170810-${TARGET}-${flavour%64}.config
	linux=linux-2.6.32.43-0.4.1.xs1.8.0.865.170810$flavour

	cp -la linux-2.6.32.43-0.4.1.xs1.8.0.865.170810 $linux

	echo .xs1.8.0.865.170810$flavour > $linux/localversion

	make -C $linux ${MAKEOPTS} mrproper

	cp $config $linux/.config
}

%if %{buildxen}
Setup xen
%endif

%if %{buildutility}
Setup utility
%endif

%if %{buildkdump}
Setup kdump
%endif

%build

Build() {
	flavour=$1
	linux=linux-2.6.32.43-0.4.1.xs1.8.0.865.170810$flavour

	%{DEFINE_MAKEOPTS}

	make -C $linux ${MAKEOPTS} silentoldconfig

	# XXX it would be nice to integrate the vmlinuz target with
	# the native arch/x86/boot/ Makefiles for kdump kernels.
	# linux-2.6.18-xen.hg 211:c1f5d027adf7 does this.

	case $flavour in
	    xen*|utility) mktarget=vmlinuz ;;
	    kdump*)       mktarget=vmlinux ;;
	    *)            exit 1 ;; # unknown
	esac

	if grep -q ^CONFIG_MODULES=y$ $linux/.config ; then
	    mkmodules=modules
	else
	    mkmodules=
	fi

	make -C $linux ${MAKEOPTS} $mktarget $mkmodules

	case $flavour in
	    kdump*)
		${CROSS_COMPILE}objcopy --strip-debug --strip-unneeded \
	            $linux/vmlinux $linux/vmlinux-stripped
		gzip --force --verbose --best --stdout $linux/vmlinux-stripped > $linux/arch/x86/boot/vmlinuz
	    ;;
	    *) ;; # no special behavior
	esac

%if %{with_kabichk}
	chmod 0755 $RPM_SOURCE_DIR/check-kabi
	if [ -e $RPM_SOURCE_DIR/Module.kabi-$flavour ]; then
	    $RPM_SOURCE_DIR/check-kabi -k $RPM_SOURCE_DIR/Module.kabi-$flavour -s $linux/Module.symvers || exit 1
	fi
%endif

}


%if %{buildxen}
Build xen
%endif

%if %{buildutility}
Build utility
%endif

%if %{buildkdump}
Build kdump
%endif

%install

Install() {
	flavour=$1
	uname=%{uname}$flavour

	%{DEFINE_MAKEOPTS}

	cd linux-2.6.32.43-0.4.1.xs1.8.0.865.170810$flavour

	# Install kernel
	mkdir -p $RPM_BUILD_ROOT/boot
	install -m 644 .config $RPM_BUILD_ROOT/boot/config-${uname}
	install -m 644 System.map $RPM_BUILD_ROOT/boot/System.map-${uname}
	cp arch/x86/boot/vmlinuz $RPM_BUILD_ROOT/boot/vmlinuz-${uname}

	if grep -q ^CONFIG_MODULES=y$ .config ; then
	    # Install modules
	    mkdir -p $RPM_BUILD_ROOT/lib/modules/${uname}
	    make ${MAKEOPTS} INSTALL_MOD_PATH=$RPM_BUILD_ROOT modules_install
	    # mark modules executable so that strip-to-file can strip them
	    find $RPM_BUILD_ROOT/lib/modules/${uname} -name "*.ko" -type f  | xargs chmod u+x

	    # Remove files created by depmod. These are recreated at install time.
	    rm -f $RPM_BUILD_ROOT/lib/modules/${uname}/modules.*
	else
	    mkdir -p $RPM_BUILD_ROOT/lib/modules/${uname}
	fi

	# Save debuginfo
	mkdir -p $RPM_BUILD_ROOT/usr/lib/debug/lib/modules/${uname}
	cp vmlinux $RPM_BUILD_ROOT/usr/lib/debug/lib/modules/${uname}

	# Install -devel files
	mkdir -p $RPM_BUILD_ROOT/usr/src/kernels/${uname}-${TARGET}

	# Setup -devel links correctly
	SOURCE=/usr/src/kernels/${uname}-${TARGET}
	rm -f $RPM_BUILD_ROOT/lib/modules/${uname}/build
	rm -f $RPM_BUILD_ROOT/lib/modules/${uname}/source
	ln -sf $SOURCE $RPM_BUILD_ROOT/lib/modules/${uname}/source
	ln -sf $SOURCE $RPM_BUILD_ROOT/lib/modules/${uname}/build

	mkdir -p $RPM_BUILD_ROOT${SOURCE}
	mkdir -p $RPM_BUILD_ROOT${SOURCE}/arch/x86
	mkdir -p $RPM_BUILD_ROOT${SOURCE}/arch/x86/kernel/

	cp --parents `find  -type f -name "Makefile*" -o -name "Kconfig*"` $RPM_BUILD_ROOT${SOURCE}
	cp localversion $RPM_BUILD_ROOT${SOURCE}
	if [ -e Module.symvers ]; then
	    cp Module.symvers $RPM_BUILD_ROOT${SOURCE}
	fi
	if [ -e $RPM_SOURCE_DIR/Module.kabi-$flavour ] ; then
	    cp $RPM_SOURCE_DIR/Module.kabi-$flavour $RPM_BUILD_ROOT${SOURCE}/Module.kabi
	fi
	# then drop all but the needed Makefiles/Kconfig files
	rm -rf $RPM_BUILD_ROOT${SOURCE}/Documentation
	rm -rf $RPM_BUILD_ROOT${SOURCE}/scripts
	rm -rf $RPM_BUILD_ROOT${SOURCE}/include
	cp arch/x86/kernel/asm-offsets.s $RPM_BUILD_ROOT${SOURCE}/arch/x86/kernel || :
	cp .config $RPM_BUILD_ROOT${SOURCE}
	cp .kernelrelease $RPM_BUILD_ROOT${SOURCE} || :
	cp -a scripts $RPM_BUILD_ROOT${SOURCE}
	cp -a arch/x86/scripts $RPM_BUILD_ROOT${SOURCE}/arch/x86 || :
	cp -a arch/x86/*lds $RPM_BUILD_ROOT${SOURCE}/arch/x86/ || :
	rm -f $RPM_BUILD_ROOT${SOURCE}/scripts/*.o
	rm -f $RPM_BUILD_ROOT${SOURCE}/scripts/*/*.o

	mkdir -p $RPM_BUILD_ROOT${SOURCE}/arch/x86/include
	if [ -d arch/x86/include ] ; then
	    cd arch/x86/include
	    cp -a asm mach-xen $RPM_BUILD_ROOT${SOURCE}/arch/x86/include
	    cd ../../../
        fi

	mkdir -p $RPM_BUILD_ROOT${SOURCE}/include
	cd include
	dirs=$(find * -maxdepth 0 -path asm-\* -prune -o -type d -print)
	cp -a ${dirs} asm-generic $RPM_BUILD_ROOT${SOURCE}/include
	if [ ! -d ../arch/x86/include ] ; then
	    cp -a `readlink asm` $RPM_BUILD_ROOT${SOURCE}/include
	fi

	# Make sure the Makefile and version.h have a matching timestamp so that
	# external modules can be built
	touch -r $RPM_BUILD_ROOT${SOURCE}/Makefile $RPM_BUILD_ROOT${SOURCE}/include/linux/version.h
	touch -r $RPM_BUILD_ROOT${SOURCE}/.config $RPM_BUILD_ROOT${SOURCE}/include/linux/autoconf.h

	cd .. # include

	case $flavour in
	    xen*)
		make ARCH=%{hdrarch} INSTALL_HDR_PATH=$RPM_BUILD_ROOT/usr headers_install
		# glibc provides scsi headers for itself, for now
		rm -rf $RPM_BUILD_ROOT/usr/include/scsi
		rm -f $RPM_BUILD_ROOT/usr/include/asm*/atomic.h
		rm -f $RPM_BUILD_ROOT/usr/include/asm*/io.h
		rm -f $RPM_BUILD_ROOT/usr/include/asm*/irq.h
		find $RPM_BUILD_ROOT/usr/include \( -name ..install.cmd -o -name .install \) -delete
	    ;;
	    *) ;; # no special behavior
	esac

	cd .. # linux-2.6.32.43-0.4.1.xs1.8.0.865.170810$flavour
}

%if %{buildxen}
Install xen
%endif

%if %{buildutility}
Install utility
%endif

%if %{buildkdump}
Install kdump
%endif

%if %{buildsource}
mkdir $RPM_BUILD_ROOT/usr/src/linux-%{uname}
tar -C linux-2.6.32.43-0.4.1.xs1.8.0.865.170810 -cf - . | tar -C $RPM_BUILD_ROOT/usr/src/linux-%{uname} -xf -
%endif

%if %{buildextradevel}
mkdir $RPM_BUILD_ROOT/usr/src/linux-%{uname}
tar -C linux-2.6.32.43-0.4.1.xs1.8.0.865.170810 -cf - drivers/base/base.h | tar -C $RPM_BUILD_ROOT/usr/src/linux-%{uname} -xf -
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%if %{buildxen}
%post xen
exe=/sbin/new-kernel-pkg
if [ -x /sbin/new-kernel-pkg.py ] ; then
  exe=/sbin/new-kernel-pkg.py
fi
if grep -qs control_d /proc/xen/capabilities ; then
  args=--multiboot=/boot/xen.gz
fi

$exe --install --package kernel-xen --mkinitrd --depmod --make-default $args %{xen_uname}

%preun xen
exe=/sbin/new-kernel-pkg
if [ -x /sbin/new-kernel-pkg.py ] ; then
  exe=/sbin/new-kernel-pkg.py
fi

$exe --remove --package kernel-xen --rminitrd --rmmoddep %{xen_uname}
%endif

%if %{buildkdump}
%post kdump
if [ -x /sbin/new-kernel-pkg.py ] ; then
  /sbin/new-kernel-pkg.py --install --mkinitrd --depmod %{kdump_uname}
fi

%preun kdump
if [ -x /sbin/new-kernel-pkg.py ] ; then
  /sbin/new-kernel-pkg.py --remove --rminitrd --rmmoddep %{kdump_uname}
fi
%endif

%if %{buildxen}
%files xen
%defattr(-,root,root)
/boot/vmlinuz-%{xen_uname}
/boot/System.map-%{xen_uname}
/boot/config-%{xen_uname}
%dir /lib/modules/%{xen_uname}
/lib/modules/%{xen_uname}/kernel

%files xen-devel
%defattr(-,root,root)
/lib/modules/%{xen_uname}/build
/lib/modules/%{xen_uname}/source
%verify(not mtime) /usr/src/kernels/%{xen_uname}-%{target}

%files headers
%defattr(-,root,root)
/usr/include/*
%endif

%if %{buildutility}
%files utility
%defattr(-,root,root)
/boot/vmlinuz-%{utility_uname}
/boot/System.map-%{utility_uname}
/boot/config-%{utility_uname}
%dir /lib/modules/%{utility_uname}

%files utility-devel
%defattr(-,root,root)
/lib/modules/%{utility_uname}/build
/lib/modules/%{utility_uname}/source
%verify(not mtime) /usr/src/kernels/%{utility_uname}-%{target}
%endif

%if %{buildkdump}
%files kdump
%defattr(-,root,root)
/boot/vmlinuz-%{kdump_uname}
/boot/System.map-%{kdump_uname}
/boot/config-%{kdump_uname}
%dir /lib/modules/%{kdump_uname}
/lib/modules/%{kdump_uname}/kernel

%files kdump-devel
%defattr(-,root,root)
/lib/modules/%{kdump_uname}/build
/lib/modules/%{kdump_uname}/source
%verify(not mtime) /usr/src/kernels/%{kdump_uname}-%{target}
%endif

%if %{buildsource}
%files sourcecode
%defattr(-,root,root)
/usr/src/linux-%{uname}
%endif

%if %{buildfirmware}
%files firmware
%defattr(-,root,root)
/lib/firmware/
%endif

%if %{buildextradevel}
%files extra-devel
%defattr(-,root,root)
/usr/src/linux-%{uname}
%endif

%changelog
* Wed Dec 09 2015 Citrix Systems, Inc. <www.citrix.com> [2.6.32.43-0.4.1.xs1.8.0.865.170810]
- Kernel patched for Xen.

