# -*- rpm-spec -*-

Summary: Performance tools
Name:    perf-tools
Version: 0.1.2
Release: 136
Group:   System/Hypervisor
License: LGPL+linking exception
URL:  http://www.xen.org
Source0: perf-tools-%{version}.tar.bz2
Source1: tdk_5.319.43.tar.gz
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
Performance tools

%package xsiostat
Summary: storage performance monitoring tool
Group: System/Hypervisor

%description xsiostat
Storage performance monitoring tool

%package xsifstat
Summary: network performance monitoring tool
Group: System/Hypervisor

%description xsifstat
Network performance monitoring tool

%package rrd2csv
Summary: Live RRD to CSV tool.
Group: System/Hypervisor

%description rrd2csv
This package contains the rrd2csv tool, useful to expose live RRDD metrics on standard output, in the CSV format.

%package rrdd-gpumon
Summary: RRDD GPU metrics plugin.
Group: System/Hypervisor

%description rrdd-gpumon
This package contains a plugin registering to the RRD daemon and exposing GPU metrics.

%package rrdd-plugins
Summary: RRDD metrics plugins.
Group: System/Hypervisor

%description rrdd-plugins
This package contains plugins registering to the RRD daemon and exposing various metrics.

%prep
%setup -q
cd $RPM_BUILD_DIR
tar zxvf /obj/SOURCES/tdk_5.319.43.tar.gz
cp $RPM_BUILD_DIR/tdk_5.319.43/nvml/include/nvml.h /usr/include

%build
mkdir -p $RPM_BUILD_ROOT
DESTDIR=$RPM_BUILD_ROOT %{__make} compile

%install
rm -rf %{buildroot}
DESTDIR=$RPM_BUILD_ROOT %{__make} install

%clean
rm -rf $RPM_BUILD_ROOT

%pre rrdd-gpumon
# Attempt to stop the GPU monitor if we're not in the host installer and it has already been installed
[ -z "$XS_INSTALLATION" ] && [ $1 -eq 2 ] && service xcp-rrdd-gpumon stop
exit 0

%post rrdd-gpumon
[ -x /sbin/chkconfig ] && chkconfig --add xcp-rrdd-gpumon
# Start the plugin now if we're not in the host installer
[ -z "$XS_INSTALLATION" ] && service xcp-rrdd-gpumon start
exit 0

%preun rrdd-gpumon
# Run chkconfig --del if this is an uninstall (rather than an upgrade)
[ $1 -eq 0 ] && [ -x /sbin/chkconfig ] && chkconfig --del xcp-rrdd-gpumon
exit 0

%pre rrdd-plugins
# Attempt to stop the plugins if we're not in the host installer and they have already been installed
[ -z "$XS_INSTALLATION" ] && [ $1 -eq 2 ] && service xcp-rrdd-plugins stop
exit 0

%post rrdd-plugins
[ -x /sbin/chkconfig ] && chkconfig --add xcp-rrdd-plugins
# Start the plugins now if we're not in the host installer
[ -z "$XS_INSTALLATION" ] && service xcp-rrdd-plugins start
exit 0

%preun rrdd-plugins
# Run chkconfig --del if this is an uninstall (rather than an upgrade)
[ $1 -eq 0 ] && [ -x /sbin/chkconfig ] && chkconfig --del xcp-rrdd-plugins
exit 0

%files xsiostat
%defattr(-,root,root,-)
/opt/xensource/debug/xsiostat

%files xsifstat
%defattr(-,root,root,-)
/opt/xensource/debug/xsifstat

%files rrd2csv
%defattr(-,root,root,-)
/opt/xensource/bin/rrd2csv
/opt/xensource/man/man1/rrd2csv.1.man

%files rrdd-gpumon
%defattr(-,root,root,-)
/etc/rc.d/init.d/xcp-rrdd-gpumon
/opt/xensource/libexec/xcp-rrdd-plugins/xcp-rrdd-gpumon

%files rrdd-plugins
%defattr(-,root,root,-)
/etc/rc.d/init.d/xcp-rrdd-plugins
/etc/sysconfig/xcp-rrdd-plugins
/opt/xensource/libexec/xcp-rrdd-plugins/xcp-rrdd-iostat
/opt/xensource/libexec/xcp-rrdd-plugins/xcp-rrdd-squeezed
/opt/xensource/libexec/xcp-rrdd-plugins/xcp-rrdd-xenpm
/etc/xensource/bugtool/xcp-rrdd-plugins.xml
/etc/xensource/bugtool/xcp-rrdd-plugins/stuff.xml

%changelog
