# -*- rpm-spec -*-

Summary: xapi - xen toolstack for XCP
Name:    xapi
Version: 0.2
Release: 6200
Group:   System/Hypervisor
License: LGPL+linking exception
URL:  http://www.xen.org
Source0: xapi-%{version}.tar.bz2
Source1: jquery-1.1.3.1.pack.js
Source2: jquery.treeview.zip
Patch0: xapi-version.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: pam-devel tetex-latex xapi-libs-devel ocaml omake ocaml-findlib ocaml-xmlm ocaml-type-conv ocaml-xmlm-devel xen-devel zlib-devel

%description
XCP toolstack.

%package core
Summary: The xapi toolstack
Group: System/Hypervisor

%description core
This package contains the xapi toolstack.

%package xe
Summary: The xapi toolstack CLI
Group: System/Hypervisor

%description xe
The command-line interface for controlling XCP hosts.

%package tests
Summary: Toolstack test programs
Group: System/Hypervisor

%description tests
This package contains a series of simple regression tests.

%package squeezed
Summary: The memory ballooning daemon
Group: System/Hypervisor

%description squeezed
This package contains the Xen virtual firmware (hvmloader)

%package xenopsd
Summary: The xenops daemon
Group: System/Hypervisor

%description xenopsd
This package contains the xenops daemon.

%package v6d
Summary: The editions and features daemon
Group: System/Hypervisor

%description v6d
This package contains daemon that defines and controls XCP editions and
associated features

%package networkd
Summary: The networking daemon
Group: System/Hypervisor

%description networkd
This package contains a daemon that is able to configure network
interfaces and bridges

%package rrdd
Summary: The RRD daemon
Group: System/Hypervisor

%description rrdd
This package contains a daemon that continually collects performance metrics
from the host and its VMs, stores the data in host's memory, and occasionally
synchronises the data to host's local storage.

%package xenops
Summary: Low-level debugging tools
Group: System/Hypervisor

%description xenops
This package contains the xenops-based low-level debugging tools.

%package client-devel
Summary: xapi Development Headers and Libraries
Group:   Development/Libraries

%description client-devel
This package contains the xapi development libraries and header files
for building addon tools.

%package datamodel-devel
Summary: xapi Datamodel headers and libraries
Group:   Development/Libraries

%description datamodel-devel
This package contains the internal xapi datamodel as a library suitable
for writing additional code generators.

%package rrd-devel
Summary: rrd-client headers and libraries
Group:   Development/Libraries

%description rrd-devel
This package contains rrd functions as a library suitable for writing tools 
related to rrd. Needed for rrd2csv and rrdd-plugins.

%package xenstore-watch-devel
Summary: xenstore-watch headers and libraries
Group:   Development/Libraries

%description xenstore-watch-devel
This package contains a library of functions for watching xenstore.

%prep 
%setup -q
%patch0 -p0 -b xapi-version.patch

%build
COMPILE_JAVA=no %{__make}
COMPILE_JAVA=no %{__make} test

%install
rm -rf %{buildroot}

DESTDIR=$RPM_BUILD_ROOT %{__make} install

%clean
rm -rf $RPM_BUILD_ROOT

%post core
[ ! -x /sbin/chkconfig ] || chkconfig --add xapi
[ ! -x /sbin/chkconfig ] || chkconfig --add xenservices
[ ! -x /sbin/chkconfig ] || chkconfig --add xapi-domains
[ ! -x /sbin/chkconfig ] || chkconfig --add perfmon
[ ! -x /sbin/chkconfig ] || chkconfig --add genptoken

%post networkd
[ ! -x /sbin/chkconfig ] || chkconfig --add xcp-networkd

%post rrdd
[ ! -x /sbin/chkconfig ] || chkconfig --add xcp-rrdd

%post squeezed
[ ! -x /sbin/chkconfig ] || chkconfig squeezed on

%post xenopsd
[ ! -x /sbin/chkconfig ] || chkconfig xenopsd on

%post v6d
[ ! -x /sbin/chkconfig ] || chkconfig --add v6d

%files core
%defattr(-,root,root,-)
/opt/xensource/bin/xapi
%config(noreplace) /etc/xapi.conf
/etc/logrotate.d/audit
/etc/logrotate.d/v6d
/etc/logrotate.d/xapi
/etc/pam.d/xapi
/etc/rc.d/init.d/management-interface
/etc/rc.d/init.d/perfmon
/etc/rc.d/init.d/xapi
/etc/rc.d/init.d/xapi-domains
/etc/rc.d/init.d/xapissl
/etc/rc.d/init.d/xenservices
/etc/rc.d/init.d/genptoken
%config(noreplace) /etc/sysconfig/perfmon
%config(noreplace) /etc/sysconfig/xapi
/etc/xapi.d/base-path
/etc/xapi.d/plugins/DRAC.py
/etc/xapi.d/plugins/DRAC.pyo
/etc/xapi.d/plugins/DRAC.pyc
/etc/xapi.d/plugins/echo
/etc/xapi.d/plugins/extauth-hook
/etc/xapi.d/plugins/extauth-hook-AD.py
/etc/xapi.d/plugins/extauth-hook-AD.pyo
/etc/xapi.d/plugins/extauth-hook-AD.pyc
/etc/xapi.d/plugins/iLO.py
/etc/xapi.d/plugins/iLO.pyo
/etc/xapi.d/plugins/iLO.pyc
/etc/xapi.d/plugins/iLOPowerON.xml
/etc/xapi.d/plugins/perfmon
/etc/xapi.d/plugins/power-on-host
/etc/xapi.d/plugins/wake-on-lan
/etc/xapi.d/plugins/wlan.py
/etc/xapi.d/plugins/wlan.pyo
/etc/xapi.d/plugins/wlan.pyc
/etc/xapi.d/plugins/iovirt
%config(noreplace) /etc/xensource/db.conf
%config(noreplace) /etc/xensource/db.conf.rio
/etc/xensource/master.d/01-example
/etc/xensource/master.d/03-mpathalert-daemon
%config(noreplace) /etc/xensource/pool.conf
/opt/xensource/bin/fix_firewall.sh
/opt/xensource/bin/list_domains
/opt/xensource/bin/mpathalert
/opt/xensource/bin/perfmon
/opt/xensource/bin/static-vdis
/opt/xensource/bin/xapi-autostart-vms
/opt/xensource/bin/xapi-db-process
/opt/xensource/bin/xapi-wait-init-complete
/opt/xensource/bin/xe-backup-metadata
/opt/xensource/bin/xe-edit-bootloader
/opt/xensource/bin/xe-get-network-backend
/opt/xensource/bin/xe-mount-iso-sr
/opt/xensource/bin/xe-restore-metadata
/opt/xensource/bin/xe-reset-networking
/opt/xensource/bin/xe-scsi-dev-map
/opt/xensource/bin/xe-set-iscsi-iqn
/opt/xensource/bin/xe-toolstack-restart
/opt/xensource/bin/xe-xentrace
/opt/xensource/bin/xe-switch-network-backend
/opt/xensource/bin/xe-enable-all-plugin-metrics
/opt/xensource/bin/xva-rewrite-scsiid
/etc/bash_completion.d/xe-switch-network-backend
/opt/xensource/bin/xsh
/etc/xensource/bugtool/xapi.xml
/etc/xensource/bugtool/xapi/stuff.xml
/opt/xensource/libexec/list_plugins
/opt/xensource/libexec/sm_diagnostics
/opt/xensource/libexec/thread_diagnostics
/opt/xensource/libexec/InterfaceReconfigure.py
/opt/xensource/libexec/InterfaceReconfigure.pyo
/opt/xensource/libexec/InterfaceReconfigure.pyc
/opt/xensource/libexec/InterfaceReconfigureBridge.py
/opt/xensource/libexec/InterfaceReconfigureBridge.pyo
/opt/xensource/libexec/InterfaceReconfigureBridge.pyc
/opt/xensource/libexec/InterfaceReconfigureVswitch.py
/opt/xensource/libexec/InterfaceReconfigureVswitch.pyo
/opt/xensource/libexec/InterfaceReconfigureVswitch.pyc
/opt/xensource/libexec/backup-metadata-cron
/opt/xensource/libexec/backup-sr-metadata.py
/opt/xensource/libexec/backup-sr-metadata.pyo
/opt/xensource/libexec/backup-sr-metadata.pyc
/opt/xensource/libexec/block_device_io
/opt/xensource/libexec/cdrommon
/opt/xensource/libexec/dumpcore
/opt/xensource/libexec/fence
/opt/xensource/libexec/fence.bin
/opt/xensource/libexec/generate_ssl_cert
/opt/xensource/libexec/host-backup
/opt/xensource/libexec/host-bugreport-upload
/opt/xensource/libexec/host-restore
/opt/xensource/libexec/interface-reconfigure
/opt/xensource/libexec/interface-visualise
/opt/xensource/libexec/license-check.py
/opt/xensource/libexec/license-check.pyo
/opt/xensource/libexec/license-check.pyc
/opt/xensource/libexec/link-vms-by-sr.py
/opt/xensource/libexec/link-vms-by-sr.pyo
/opt/xensource/libexec/link-vms-by-sr.pyc
/opt/xensource/libexec/logs-download
/opt/xensource/libexec/lw-force-domain-leave
/opt/xensource/libexec/mail-alarm
/opt/xensource/libexec/print-custom-templates
/opt/xensource/libexec/probe-device-for-file
/opt/xensource/libexec/genptoken
/opt/xensource/libexec/qemu-dm-wrapper
/opt/xensource/libexec/restore-sr-metadata.py
/opt/xensource/libexec/restore-sr-metadata.pyo
/opt/xensource/libexec/restore-sr-metadata.pyc
/opt/xensource/libexec/set-hostname
/opt/xensource/libexec/shell.py
/opt/xensource/libexec/shell.pyo
/opt/xensource/libexec/shell.pyc
/opt/xensource/libexec/shutdown
%exclude /opt/xensource/libexec/sparse_dd
%exclude /etc/sparse_dd.conf
/opt/xensource/libexec/update-mh-info
/opt/xensource/libexec/upload-wrapper
/opt/xensource/libexec/vncterm-wrapper
/opt/xensource/libexec/xapi-health-check
/opt/xensource/libexec/xapi-rolling-upgrade
/opt/xensource/libexec/xenguest
/opt/xensource/libexec/xha-lc
/opt/xensource/libexec/xiu
/opt/xensource/lib/libxenctrl_xiu.so
/opt/xensource/packages/post-install-scripts/debian-etch
/opt/xensource/packages/post-install-scripts/debug
/usr/lib/python2.4/site-packages/XenAPI.py
/usr/lib/python2.4/site-packages/XenAPI.pyo
/usr/lib/python2.4/site-packages/XenAPI.pyc
/usr/lib/python2.4/site-packages/XenAPIPlugin.py
/usr/lib/python2.4/site-packages/XenAPIPlugin.pyo
/usr/lib/python2.4/site-packages/XenAPIPlugin.pyc
/usr/lib/python2.4/site-packages/inventory.py
/usr/lib/python2.4/site-packages/inventory.pyo
/usr/lib/python2.4/site-packages/inventory.pyc
/var/xapi/udhcpd.skel
/opt/xensource/debug/rbac_static.csv
/etc/xapi.d/host-post-declare-dead/10resetvdis

%files xe
%defattr(-,root,root,-)
/opt/xensource/bin/xe
/opt/xensource/debug/sm
/usr/bin/xe
/etc/bash_completion.d/xe

%files squeezed
%defattr(-,root,root,-)
/opt/xensource/libexec/squeezed
/etc/rc.d/init.d/squeezed
%config(noreplace) /etc/squeezed.conf

%files xenopsd
%defattr(-,root,root,-)
/opt/xensource/libexec/xenopsd
/etc/rc.d/init.d/xenopsd
%config(noreplace) /etc/xenopsd.conf
/opt/xensource/bin/xn
/usr/bin/xn
/etc/xensource/bugtool/xenopsd.xml
/etc/xensource/bugtool/xenopsd/stuff.xml
/opt/xensource/libexec/xn_diagnostics
/opt/xensource/libexec/domain_sethandle

%files v6d
%defattr(-,root,root,-)
/opt/xensource/libexec/v6d
/etc/rc.d/init.d/v6d

%files networkd
%defattr(-,root,root,-)
/opt/xensource/libexec/xcp-networkd
/etc/rc.d/init.d/xcp-networkd
/opt/xensource/libexec/networkd_db

%files rrdd
%defattr(-,root,root,-)
/opt/xensource/libexec/xcp-rrdd
/etc/rc.d/init.d/xcp-rrdd
%config(noreplace) /etc/xcp-rrdd.conf
/usr/lib/python2.4/site-packages/rrdd.py
/usr/lib/python2.4/site-packages/rrdd.pyc
/usr/lib/python2.4/site-packages/rrdd.pyo
/opt/xensource/libexec/rrdd-example.py
/opt/xensource/libexec/rrdd-example.pyc
/opt/xensource/libexec/rrdd-example.pyo

%files xenops
%defattr(-,root,root,-)
/opt/xensource/debug/xenops
/opt/xensource/debug/add_vbd
/opt/xensource/debug/add_vif
/opt/xensource/debug/build_domain
/opt/xensource/debug/build_hvm
/opt/xensource/debug/create_domain
/opt/xensource/debug/debug_ha_query_liveset
/opt/xensource/debug/destroy_domain
/opt/xensource/debug/event_listen
/opt/xensource/debug/graph
/opt/xensource/debug/memory_breakdown
/opt/xensource/debug/memory_summary
/opt/xensource/debug/pause_domain
/opt/xensource/debug/restore_domain
/opt/xensource/debug/shutdown_domain
/opt/xensource/debug/sm_stress
/opt/xensource/debug/suspend_domain
/opt/xensource/debug/unpause_domain
/opt/xensource/debug/vncproxy
/opt/xensource/debug/with-vdi
/opt/xensource/debug/xs

%files tests
%defattr(-,root,root,-)
/etc/xapi.d/plugins/lvhdrt-helper
/etc/xapi.d/plugins/lvhdrt-trash-vdi
/etc/xapi.d/plugins/multipathrt-helper
/opt/xensource/debug/cli-rt-domu-shar.sh
/opt/xensource/debug/cli_test
/opt/xensource/debug/install-debian-pv-inside.sh
/opt/xensource/debug/install-debian-pv.sh
/opt/xensource/debug/lvhdrt
/opt/xensource/debug/multipathrt
/opt/xensource/debug/myfirstpatch.asc
/opt/xensource/debug/perftest
/opt/xensource/debug/quicktest
/opt/xensource/debug/quicktestbin
/cli-rt/*

%files client-devel
%defattr(-,root,root,-)
/usr/lib/ocaml/xapi-client/*

%files datamodel-devel
%defattr(-,root,root,-)
/usr/lib/ocaml/xapi-datamodel/*

%files rrd-devel
%defattr(-,root,root,-)
/usr/lib/ocaml/rrd-client/*

%files xenstore-watch-devel
%defattr(-,root,root,-)
/usr/lib/ocaml/xenstore-watch/*

%changelog








