# -*- rpm-spec -*-
%{!?python_sitearch: %define python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

%define COMMON_OPTIONS DESTDIR=%{buildroot} %{?_smp_mflags} XEN_CHANGESET="23509:aa273b47bcbe, pq 654:f8520bf37163" XEN_PYTHON_NATIVE_INSTALL=1

%ifarch %ix86
%if y == y
%define HVSOR_OPTIONS XEN_TARGET_ARCH=x86_64 CROSS_COMPILE=x86_64-linux- max_phys_cpus=256
%define TOOLS_OPTIONS XEN_TARGET_ARCH=x86_32 XEN_TARGET_X86_PAE=y
%else
%define HVSOR_OPTIONS XEN_TARGET_ARCH=x86_32 XEN_TARGET_X86_PAE=y
%define TOOLS_OPTIONS XEN_TARGET_ARCH=x86_32 XEN_TARGET_X86_PAE=y
%endif
%endif

%ifarch x86_64
%define HVSOR_OPTIONS XEN_TARGET_ARCH=x86_64 max_phys_cpus=256
%define TOOLS_OPTIONS XEN_TARGET_ARCH=x86_64
%endif

Summary: Xen is a virtual machine monitor
Name:    xen
Version: 4.1.5
Release: 1.8.0.654.23862
Group:   System/Hypervisor
License: GPL
URL:  http://www.xen.org
Source0: xen-%{version}.tar.bz2
Patch0: xen-development.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-root
BuildRequires: zlib-devel python-devel ncurses-devel e2fsprogs-devel tetex dev86 x86_64-linux-gcc x86_64-linux-binutils openssl-devel gettext e4fsprogs-devel ocaml

# latex
ExclusiveArch: i386 i686 x86_64

%description
Xen hypervisor.

%package hypervisor
Summary: The Xen Hypervisor
Group: System/Hypervisor

%description hypervisor
This package contains the Xen Hypervisor.

%package firmware
Summary: The Xen virtual firmware (hvmloader)
Group: System/Hypervisor

%description firmware
This package contains the Xen virtual firmware (hvmloader)

%package tools
Summary: Xen Tools
Requires: xen-hypervisor = %{version}

Group: System/Hypervisor

%description tools
The Xen userspace tools

%package devel
Summary: Xen Development Headers and Libraries
Requires: xen-hypervisor = %{version} xen-tools = %{version}
Group:   Development/Libraries

%description devel
This package contains the Xen development libraries and header files
for building addon tools.

%prep 
%setup -q
%patch0 -p1 -b ~development

%build
%{__make} %{COMMON_OPTIONS} %{HVSOR_OPTIONS} XEN_CHANGESET="23509:aa273b47bcbe, pq 654:f8520bf37163" xen
%{__make} %{COMMON_OPTIONS} %{TOOLS_OPTIONS} tools
%{__make} %{COMMON_OPTIONS} %{HVSOR_OPTIONS} -C xen MAP

# Set GDB_MIRROR to something invalid so we fail the build instead of
# downloading.
( cd tools/debugger/gdb && GDB_MIRROR="GDB_NOT_IN_DISTFILES" ./gdbbuild )

%install
rm -rf %{buildroot}

%{__make} %{COMMON_OPTIONS} %{HVSOR_OPTIONS} install-xen
%{__make} %{COMMON_OPTIONS} %{TOOLS_OPTIONS} install-tools

mkdir -p $RPM_BUILD_ROOT/%{_docdir}/%{name}/
for name in COPYING README; do 
  cp -p $name $RPM_BUILD_ROOT/%{_docdir}/%{name}/
done
cat > $RPM_BUILD_ROOT/%{_docdir}/%{name}/CHANGESET <<EOF
Xen build from %{name} version trunk.aa273b47bcbe.f8520bf37163
EOF

cp xen/System.map $RPM_BUILD_ROOT/boot/xen-4.1.5.map

rm -rf $RPM_BUILD_ROOT/%{_libdir}/pkgconfig
rm -rf $RPM_BUILD_ROOT/usr/share/info

# Don't use the C xenstored
rm -f %{buildroot}%{_sbindir}/xenstored

# Copy ocaml xenstored to legacy location until we can fix up the init scripts
mkdir -p $RPM_BUILD_ROOT/opt/xensource/bin/
cp -f %{buildroot}%{_sbindir}/oxenstored %{buildroot}/opt/xensource/bin/xenstored

rm -f %{buildroot}%{_includedir}/%{name}/COPYING

%ifarch x86_64
ln -s %{_libdir}/%{name}/bin %{buildroot}/usr/lib/%{name}/bin
%endif

%clean
rm -rf $RPM_BUILD_ROOT

%files hypervisor
%defattr(-,root,root)
/boot/%{name}*.gz
/boot/%{name}*.map

%files tools
%defattr(-,root,root)
%{_docdir}/%{name}/CHANGESET
%{_docdir}/%{name}/README
%{_docdir}/%{name}/README.*
%{_docdir}/%{name}/COPYING
%{_bindir}/lomount
%{_bindir}/pygrub
%{_sysconfdir}/pygrub/rules.d
%{_sysconfdir}/pygrub/rules.d/*
%{_bindir}/xencons
%{_bindir}/xeninfo
%{_bindir}/xenstore
%{_bindir}/xenstore-*
%{_bindir}/xentrace*
%{_bindir}/xen-detect
%{_sysconfdir}/bash_completion.d/xl.sh
%{_sysconfdir}/xen/xl.conf
%{_sbindir}/xl
%{_sbindir}/xenpaging
%{_sbindir}/xen-hvmctx
%{_sbindir}/kdd
%{_sbindir}/xen-hptool
%{_sbindir}/xen-python-path
%{_sbindir}/xenbaked
%{_sbindir}/xenconsoled
%{_sbindir}/xenmon.py
%{_sbindir}/xenmon.pyc
%{_sbindir}/xenmon.pyo
%{_sbindir}/xenperf
%{_sbindir}/xenpm
%{_sbindir}/xenpmd
%{_sbindir}/xentop
%{_sbindir}/xen-hvmcrash
%{_sbindir}/xentrace_setmask
%{_mandir}/man?/*.?.gz
%{_libdir}/libxenctrl*.so.*
%{_libdir}/libxenguest*.so.*
%{_libdir}/libxenstore*.so.*
%{_libdir}/libxenvchan*.so.*
%{_libdir}/libxenlight*.so.*
%{_libdir}/libxlutil*.so.*
%{_libdir}/libfsimage*.so.*
%{_libdir}/fs/*/*.so
%{_libdir}/%{name}/bin/readnotes
%{_libdir}/%{name}/bin/xenconsole
%{_libdir}/%{name}/bin/xenctx
%{_libdir}/%{name}/bin/lsevtchn
%{_libdir}/%{name}/bin/crash_guest
%ifarch x86_64
/usr/lib/%{name}/bin
%endif
%{python_sitearch}/grub
%{python_sitearch}/%{name}
%{python_sitearch}/fsimage.so
%dir /var/run/xend/boot
%dir /var/log/xen
%dir /var/lib/xen
%{_sysconfdir}/rc.d/init.d/*
/etc/xen/oxenstored.conf
/usr/sbin/oxenstored
/opt/xensource/bin/xenstored
%{_sbindir}/xenwatchdogd
%{_sbindir}/xen-ringwatch

%files firmware
%{_exec_prefix}/lib/%{name}/boot/hvmloader

%files devel
%defattr(-,root,root)
%dir %{_includedir}/%{name}
/boot/%{name}-syms*
%{_libdir}/libxenctrl*.a
%{_libdir}/libxenguest*.a
%{_libdir}/libxenstore*.a
%{_libdir}/libxenlight*.a
%{_libdir}/libxlutil*.a
%{_libdir}/libxenctrl*.so
%{_libdir}/libxenguest*.so
%{_libdir}/libxenstore*.so
%{_libdir}/libxenvchan*.so
%{_libdir}/libfsimage*.so
%{_libdir}/libxenlight*.so
%{_libdir}/libxlutil*.so
%{_libdir}/ocaml
%{_includedir}/%{name}/*.h
%{_includedir}/%{name}/*/*.h
%{_includedir}/%{name}/*/*/*.h
%{_includedir}/fsimage.h
%{_includedir}/fsimage_grub.h
%{_includedir}/fsimage_plugin.h
%{_includedir}/xenctrl.h
%{_includedir}/xenctrlosdep.h
%{_includedir}/xentoollog.h
%{_includedir}/xenguest.h
%{_includedir}/xs.h
%{_includedir}/xs_lib.h
%{_includedir}/libxl.h
%{_includedir}/libxl_uuid.h
%{_includedir}/_libxl_types.h
%{_includedir}/libxenvchan.h
%changelog
* Thu Nov 26 2015 Citrix Systems, Inc. <www.citrix.com> [4.1.5 1.8.0.654.23862]
- Build Xen hypervisor.

