import MySQLdb
import sys
from optparse import OptionParser


class SystemTmplUpgradeUtl:

    def __init__(self, host, db, user, passwd):
        self.host = host
        self.user = user
        self.db = db
        self.passwd = passwd
        self.conn = None
        self.hypervisorsListInUse = set()
        self.__initHypervisorValues()

    def __connect(self):
        self.conn = MySQLdb.connect(
            host=self.host,
            user=self.user,
            passwd=self.passwd,
            db=self.db)
        self.conn.autocommit(False)
        print "\n=== DB Connection Successful ==="

    def __getHyperVisorType(self):
        cursor = self.conn.cursor()
        try:
            cmd = "select distinct(hypervisor_type) from `cloud`.`cluster` where removed is null"
            hypervisor_types = cursor.execute(cmd)
            rows = cursor.fetchall()
            for hypervisor_type in rows:
                self.hypervisorsListInUse.add(hypervisor_type[0])
            self.conn.commit()
        except Exception,e:
            print "EXC",e
            self.conn.rollback()

    def __initHypervisorValues(self):
        self.newTemplateNameDict = {"XenServer": "systemvm-xenserver-4.3-b",
                                    "VMware": "systemvm-vmware-4.3-a",
                                    "KVM": "systemvm-kvm-4.3-a",
                                    "LXC": "systemvm-lxc-4.3-a",
                                    "Hyperv": "systemvm-hyperv-4.3-a"}
        self.routerTemplateConfigurationNames = {
            "XenServer": "router.template.xen",
            "VMware": "router.template.vmware",
            "KVM": "router.template.kvm",
            "LXC": "router.template.lxc",
            "Hyperv": "router.template.hyperv"}
        self.newTemplateUrl = {
            "XenServer": "http://download.cloud.com/templates/4.3/systemvm64template-2014-04-10-master-xen.vhd.bz2",
            "VMware": "http://download.cloud.com/templates/4.3/systemvm64template-2014-04-13-master-vmware.ova",
            "KVM": "http://download.cloud.com/templates/4.3/systemvm64template-2014-04-10-master-kvm.qcow2.bz2",
            "LXC": "http://download.cloud.com/templates/4.3/systemvm64template-2014-04-10-master-kvm.qcow2.bz2",
            "Hyperv": "http://download.cloud.com/templates/4.3/systemvm64template-2014-04-10-master-xen.vhd.bz2"}
        self.newTemplateChecksum = {
            "XenServer": "1a8fdd56f2be54c068a7d62906c8ef27",
            "VMware": "2b6cc465988cf78d8801265af22e3e33",
            "KVM": "d61d5caae75a2facfacd245d3da7b8e1",
            "LXC": "d61d5caae75a2facfacd245d3da7b8e1",
            "Hyperv": "1a8fdd56f2be54c068a7d62906c8ef27"}

    def TmplUpgrade(self):
        self.__connect()
        self.__getHyperVisorType()
        for hyper, template in self.newTemplateNameDict.items():
            print "\n==== Updating " + str(hyper) + " System Vms ===\n"
            try:
                cursor = self.conn.cursor()
                cmd = "select id from `cloud`.`vm_template` where name = '" +  str(template) + "' and removed is null order by id desc limit 1" 
                rows = cursor.execute(cmd)
                if(rows ):
                    templateId = cursor.fetchone()[0]
                    cursor.execute("update `cloud`.`vm_template` set type='SYSTEM' where id = " + str(templateId))
                    cursor.execute("update `cloud`.`vm_instance` set vm_template_id = " +
                                   str(templateId) + " where type <> 'User' and hypervisor_type = '" + hyper + "'")
                    cursor.execute(
                        "UPDATE `cloud`.`configuration` SET value = '" +
                        template +
                        "' WHERE name = '" +
                        self.routerTemplateConfigurationNames.get(
                            hyper) + "'")
                else:
                    if ( str(hyper) in self.hypervisorsListInUse):
                        print "4.3.0 " + hyper + \
                            " SystemVm template not found. Cannot upgrade system Vms"
                        sys.exit(1)
                    else:
                        print "4.3.0 " + hyper + " SystemVm template not found. Hypervisor is not used, so not failing upgrade"
                        template_url = self.newTemplateUrl.get(hyper)
                        template_checksum = self.newTemplateChecksum.get(hyper)
                        cursor.execute(
                            "UPDATE `cloud`.`vm_template` SET url = '" +
                            template_url +
                            "' , checksum = '" +
                            template_checksum +
                            "' WHERE hypervisor_type = '" +
                            str(
                                hyper) +
                            "' AND type = 'SYSTEM' AND removed is null order by id desc limit 1")
                self.conn.commit()
            except Exception as e:
                self.conn.rollback()
                print "Error while updating " + hyper + " systemVm template", e
        print "\nUpdating System Vm Template IDs Complete"
     
    def __del__(self):
        if self.conn: 
            self.conn.close()

if __name__ == "__main__":
    parser = OptionParser()
    parser.add_option("-i", "--host", action="store",
                      default="localhost", dest="host")
    parser.add_option("-d", "--db", action="store",
                      default="cloud", dest="db")
    parser.add_option("-u", "--user", action="store",
                      default="cloud", dest="user")
    parser.add_option("-p", "--passwd", action="store",
                      default="", dest="passwd")
    (options, args) = parser.parse_args()
    obj = SystemTmplUpgradeUtl(
        options.host,
        options.db,
        options.user,
        options.passwd)
    obj.TmplUpgrade()
