#!/bin/sh

#
# Permanently runs the zpool iostat command and keeps the last line in /tmp/zpool-iostat.cache
#
interval=60
cachefile=/tmp/processor-stats.cache.new
oldcache=/tmp/processor-stats.cache
cpus=`cat /proc/cpuinfo  | grep processor | wc -l`
all=`mpstat -P ALL | wc -l`

#mpstat -P ALL $interval | awk '{$1=""; $2=""; sub(/^[ \t]+/, ""); print $0}' | (l=0
mpstat -P ALL $interval | (l=0
read line	# skip header
while read line; do
	if [ $l -gt 1 ]
	then
		echo ${line:11} >> $cachefile
	fi
	((l++))
	if [ $l -eq $(($cpus+3)) ]
	then
		mv -f $cachefile $oldcache
		while [ $l -lt $(($all-1)) ]; do
			((l++))
			read line
		done
		l=0
	fi
done)

