#!/bin/sh

# Install DAG Repo (disabled)
rpm -qi rpmforge-release > /dev/null
if [[ $? -eq 1 ]]; then

        # Import the public key...
        rpm --import http://apt.sw.be/RPM-GPG-KEY.dag.txt
        cd /tmp
        wget -nv http://dl.fedoraproject.org/pub/epel/5/i386/epel-release-5-4.noarch.rpm
        rpm -ivh epel-release-5-4.noarch.rpm
        sed -i 's/enabled=1/enabled=0/g' /etc/yum.repos.d/epel.repo
fi

# Install NRPE
rpm -qi nagios-nrpe > /dev/null
if [[ $? -eq 1 ]]; then
        echo "Installing NRPE"
        yum -q -y --enablerepo=epel install nagios-nrpe
        chkconfig --add nrpe
        chkconfig nrpe on
        RESTARTNRPE=1
fi

# Configure NRPE
cat <<EOF > /etc/nagios/nrpe.cfg.new
#
# iCloudHosting HV NRPE Config
#
log_facility=daemon
pid_file=/var/run/nrpe.pid
server_port=5666
nrpe_user=nagios
nrpe_group=nagios

allowed_hosts=10.240.1.254

dont_blame_nrpe=0
debug=0
command_timeout=60
connection_timeout=300

command[check_root]=/usr/lib/nagios/plugins/check_disk -w 10% -c 5% -p /
command[check_nfs]=/usr/lib/nagios/plugins/check_nfs
EOF

RESTARTNRPE=0

diff /etc/nagios/nrpe.cfg.new /etc/nagios/nrpe.cfg > /dev/null
if [[ $? -eq 1 ]]; then
        mv /etc/nagios/nrpe.cfg.new /etc/nagios/nrpe.cfg
        echo "Updated NRPE Config"
        RESTARTNRPE=1
else
        rm /etc/nagios/nrpe.cfg.new
fi

if [[ $RESTARTNRPE -eq 1 ]]; then
        echo "Restarting NRPE"
        service nrpe restart
fi

